const jwt = require("jsonwebtoken");
const Joi = require("joi");
const bcrypt = require("bcryptjs");
const { Admins } = require("../models");

const authAdmin = async (req, res) => {
  try {
    const { username, password } = req.body;

    const schema = Joi.object({
      username: Joi.string().required(),
      password: Joi.string().required(),
    });

    const { error } = schema.validate(req.body);
    if (error) {
      return res.status(400).json({
        success: false,
        message: "Validation error",
        errors: error.details.map((detail) => detail.message),
      });
    }

    let admin = await Admins.findOne({
      where: { username },
    });

    if (admin) {
      const validatePassword = await bcrypt.compare(password, admin.password);
      if (validatePassword) {
        const encToken = jwt.sign(
          {
            adminId: admin.id,
            username: admin.username,
          },
          process.env.APP_SECRET,
          { expiresIn: "1h" }
        );

        req.session.adminAuth = encToken;

        return res.status(200).json({
          success: true,
          message: `Amdin logged in successfully`,
          data: encToken,
        });
      }
      return res.status(400).json({
        success: false,
        message: "Incorrect password",
        errors: ["Password provided is incorrect"],
      });
    }

    return res.status(404).json({
      success: false,
      message: "Not found",
      errors: ["Admin was not found"],
    });
  } catch (error) {
    console.error("Error authenticating admin:", error);
    return res.status(500).json({
      success: false,
      message: "Internal server error",
      errors: ["An error occurred while authenticating admin."],
    });
  }
};

module.exports = {
  authAdmin,
};
