const Joi = require('joi');
const sendMail = require('../utils/sendMail');

const sendSupportMail = async (req, res) => {
    try {
        const {
            email,
            subject,
            message
        } = req.body;

        const schema = Joi.object({
            email: Joi.string().email().required(),
            subject: Joi.string().required(),
            message: Joi.string().required()
        });

        const { error } = schema.validate(req.body);
        if(error){
            return res.status(400).json({
                status: 400,
                success: false,
                message: 'Validation error',
                errors: error.details.map(detail => detail.message),
            });
        }

        const mail = await sendMail(
            email,
            subject,
            {
                appURL: process.env.APP_URL,
                appName: process.env.APP_NAME,
                subject,
                message,
            },
            'clientEmailTemplate.ejs'
        );

        return res.status(200).json({
            status: 200,
            success: true,
            message: 'Support message sent successfully',
            data: mail
        });

    } catch (error) {
        console.error('Error mailing support:', error);
        return res.status(500).json({
            status: 500,
            success: false,
            message: 'Internal server error',
            errors: ['An error occurred while mailing support.'],
        });
    }
};




const contactSupportMail = async (req, res) => {
    try {
        const {
            fullName,
            phoneNumber,
            email,
            city,
            message
        } = req.body;

        const schema = Joi.object({
            fullName: Joi.string().required(),
            phoneNumber: Joi.number().required(),
            email: Joi.string().email().required(),
            city: Joi.string().required(),
            message: Joi.string().required()
        });

        const { error } = schema.validate(req.body);
        if(error){
            return res.status(400).json({
                status: 400,
                success: false,
                message: 'Validation error',
                errors: error.details.map(detail => detail.message),
            });
        }

        const mail = await sendMail(
            process.env.APP_SUPPORT,
            `New Support Request on ${process.env.APP_NAME}`,
            {
                appURL: process.env.APP_URL,
                appName: process.env.APP_NAME,
                fullName,
                phoneNumber,
                email,
                city,
                message
            },
            'newSupportRequest.ejs'
        );

        return res.status(200).json({
            status: 200,
            success: true,
            message: 'Support message sent successfully',
            data: mail
        });

    } catch (error) {
        console.error('Error mailing support:', error);
        return res.status(500).json({
            status: 500,
            success: false,
            message: 'Internal server error',
            errors: ['An error occurred while mailing support.'],
        });
    }
};



module.exports = {
    sendSupportMail,
    contactSupportMail
};
