const jwt = require('jsonwebtoken');
const Joi = require('joi');

const authorizeAdmin = (req, res, next) => {
    try {
        // const authorization = req.header('Authorization');

        // const schema = Joi.object({
        //     authorization: Joi.string().required(),
        // });

        // const { error } = schema.validate({ authorization });
        // if (error) {
        //     return res.status(400).json({
        //         success: false,
        //         message: 'Validation error',
        //         errors: error.details.map(detail => detail.message),
        //     });
        // }

        // const token = authorization.split(' ')[1];

        if (req.session.adminAuth) {
            jwt.verify(req.session.adminAuth, process.env.APP_SECRET, (err, payload) => {
                if(err){
                    return res.status(400).json({
                        success: false,
                        message: 'Invalid token',
                        errors: ['Token provided is invalid']
                    });
                }
                
                req.admin = payload;
                next();
            });
        }else{
            return res.status(400).json({
                success: false,
                message: 'No auth session found',
                errors: ['Auth session is required']
            });
        }
    } catch (error) {
        console.error('Error verifying token:', error);
        return res.status(500).json({
            success: false,
            message: 'Internal server error',
            errors: ['An error occurred while verifying token.'],
        });
    }
}

module.exports = authorizeAdmin;
