const jwt = require('jsonwebtoken');

const authorizeAdminView = (req, res, next) => {
	if (req.session.adminAuth) {
        jwt.verify(req.session.adminAuth, process.env.APP_SECRET, (err, payload) => {
            if(err){
                return res.redirect('/admin/signout');
            }

            next();
        });
	}else{
        return res.redirect('/admin/signout');
    }
};

module.exports = authorizeAdminView;
