'use strict';
/** @type {import('sequelize-cli').Migration} */
module.exports = {
  async up(queryInterface, Sequelize) {
    await queryInterface.createTable('Parcels', {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: Sequelize.INTEGER
      },
      parcelId: {
        type: Sequelize.UUID
      },
      trackingCode: {
        type: Sequelize.STRING,
        unique: true
      },
      parcelShipped: {
        type: Sequelize.STRING
      },
      senderName: {
        type: Sequelize.STRING
      },
      senderAddress: {
        type: Sequelize.STRING
      },
      senderPhoneNumber: {
        type: Sequelize.STRING
      },
      senderEmailAddress: {
        type: Sequelize.STRING
      },
      receiverName: {
        type: Sequelize.STRING
      },
      receiverAddress: {
        type: Sequelize.STRING
      },
      receiverPhoneNumber: {
        type: Sequelize.STRING
      },
      receiverEmailAddress: {
        type: Sequelize.STRING
      },
      parcelPaymentMode: {
        type: Sequelize.STRING
      },
      parcelWeight: {
        type: Sequelize.STRING
      },
      parcelOrigin: {
        type: Sequelize.STRING
      },
      parcelFinalDestination: {
        type: Sequelize.STRING
      },
      parcelShippingType: {
        type: Sequelize.STRING,
        defaultValue: 'Parcel'
      },
      parcelShippingMode: {
        type: Sequelize.STRING
      },
      parcelShippingDate: {
        type: Sequelize.DATE
      },
      parcelExpectedDeliveryDate: {
        type: Sequelize.DATE
      },
      parcelStatus: {
        type: Sequelize.STRING
      },
      paymentAmount: {
        type: Sequelize.STRING
      },
      isPaid: {
        type: Sequelize.BOOLEAN
      },
      createdAt: {
        allowNull: false,
        type: Sequelize.DATE
      },
      updatedAt: {
        allowNull: false,
        type: Sequelize.DATE
      }
    });
  },
  async down(queryInterface, Sequelize) {
    await queryInterface.dropTable('Parcels');
  }
};