"use strict";
const { Model } = require("sequelize");
const bcrypt = require("bcryptjs");
module.exports = (sequelize, DataTypes) => {
  class Admins extends Model {
    /**
     * Helper method for defining associations.
     * This method is not a part of Sequelize lifecycle.
     * The `models/index` file will call this method automatically.
     */
    static associate(models) {
      // define association here
    }
  }
  Admins.init(
    {
      adminId: {
        type: DataTypes.UUID,
        defaultValue: DataTypes.UUIDV4,
      },
      username: DataTypes.STRING,
      password: {
        type: DataTypes.STRING,
        async set(value) {
          this.setDataValue("password", await bcrypt.hashSync(value, 10));
        },
      },
    },
    {
      sequelize,
      modelName: "Admins",
    }
  );
  return Admins;
};
