'use strict';
const {
  Model
} = require('sequelize');
module.exports = (sequelize, DataTypes) => {
  class Parcel extends Model {
    /**
     * Helper method for defining associations.
     * This method is not a part of Sequelize lifecycle.
     * The `models/index` file will call this method automatically.
     */
    static associate(models) {
      // define association here
      this.hasMany(models.ParcelRoutes, {
        foreignKey: 'parcelId',
        onDelete: 'CASCADE'
      });
    }
  }
  Parcel.init({
    parcelId: {
      type: DataTypes.UUID,
      defaultValue: DataTypes.UUIDV4,
    },
    trackingCode: DataTypes.STRING,
    parcelShipped: DataTypes.STRING,
    senderName: DataTypes.STRING,
    senderAddress: DataTypes.STRING,
    senderPhoneNumber: DataTypes.STRING,
    senderEmailAddress: DataTypes.STRING,
    receiverName: DataTypes.STRING,
    receiverAddress: DataTypes.STRING,
    receiverPhoneNumber: DataTypes.STRING,
    receiverEmailAddress: DataTypes.STRING,
    parcelPaymentMode: DataTypes.STRING,
    parcelWeight: DataTypes.STRING,
    parcelOrigin: DataTypes.STRING,
    parcelFinalDestination: DataTypes.STRING,
    parcelShippingType: DataTypes.STRING,
    parcelShippingMode: DataTypes.STRING,
    parcelShippingDate: DataTypes.DATE,
    parcelExpectedDeliveryDate: DataTypes.DATE,
    parcelStatus: DataTypes.STRING,
    paymentAmount: DataTypes.STRING,
    isPaid: DataTypes.BOOLEAN
  }, {
    sequelize,
    modelName: 'Parcel',
  });
  return Parcel;
};