'use strict';
const {
  Model
} = require('sequelize');
module.exports = (sequelize, DataTypes) => {
  class ParcelRoutes extends Model {
    /**
     * Helper method for defining associations.
     * This method is not a part of Sequelize lifecycle.
     * The `models/index` file will call this method automatically.
     */
    static associate(models) {
      // define association here
      this.belongsTo(models.Parcel, {
        foreignKey: 'parcelId'
      });
    }
  }
  ParcelRoutes.init({
    parcelRouteId: {
      type: DataTypes.UUID,
      defaultValue: DataTypes.UUIDV4,
    },
    from: DataTypes.STRING,
    to: DataTypes.STRING,
    status: DataTypes.STRING,
    location: DataTypes.STRING,
    pointerValue: DataTypes.INTEGER
  }, {
    sequelize,
    modelName: 'ParcelRoutes',
  });
  return ParcelRoutes;
};