const express = require('express');
const router = express.Router();
const authorizeAdmin = require('../../middlewares/authorizeAdmin');

const {
    createAdmin,
    getAdmins,
    getAdmin,
    updateAdminPassword,
    deleteAdmin,
    siteStat
} = require('../../controllers/AdminController');

router.post('/admins', createAdmin);
router.get('/admins', getAdmins);
router.get('/admin', authorizeAdmin, getAdmin);
router.patch('/admin/password', authorizeAdmin, updateAdminPassword);
router.delete('/admin/:adminId', deleteAdmin);
router.get('/admin/site-stat', siteStat);

module.exports = router;
