const express = require('express');
const router = express.Router();

const {
    createParcel,
    addParcelRoute,
    getParcel,
    getParcels,
    updateParcel,
    updateParcelRoute,
    deleteParcel,
    deleteParcelRoute,
    generateInvoice,
    generateReceipt
} = require('../../controllers/ParcelController');

router.post('/parcel', createParcel);
router.post('/parcel-route', addParcelRoute);
router.get('/parcel/:trackingCode', getParcel);
router.get('/parcels', getParcels);
router.patch('/parcel/:trackingCode', updateParcel);
router.patch('/parcel-route/:parcelRouteId', updateParcelRoute);
router.delete('/parcel/:trackingCode', deleteParcel);
router.delete('/parcel-route/:parcelRouteId', deleteParcelRoute);
router.get('/parcel/generate/invoice/:parcelId', generateInvoice);
router.get('/parcel/generate/receipt/:parcelId', generateReceipt);
module.exports = router;
