const express = require('express');
const authorizeAdminView = require('../../middlewares/authorizeAdminView');

const router = express.Router();

router.get('/admin/signin', async (req, res) => {
    return res.render('admin/signin');
});

router.get('/admin/signout', async (req, res) => {
    req.session.destroy((err) => {
        if(!err){
            res.redirect('/admin/signin');
        }
    });
});

router.get('/admin/', authorizeAdminView, async (req, res) => {
    return res.redirect('/admin/dashboard');
});

router.get('/admin/dashboard', authorizeAdminView, async (req, res) => {
    return res.render('admin/dashboard', {
        activePage: 'dashboard',
    });
});

router.get('/admin/create-account', authorizeAdminView, async (req, res) => {
    return res.render('admin/create-account', {
        activePage: 'create-account'
    });
});

router.get('/admin/create-courier', authorizeAdminView, async (req, res) => {
    return res.render('admin/create-courier', {
        activePage: 'create-courier',
    });
});

router.get('/admin/update-courier/:tn', authorizeAdminView, async (req, res) => {
    return res.render('admin/update-courier', {
        activePage: 'update-courier',
    });
});

router.get('/admin/list-couriers', authorizeAdminView, async (req, res) => {
    return res.render('admin/list-couriers', {
        activePage: 'list-couriers',
    });
});

router.get('/admin/message-client', authorizeAdminView, async (req, res) => {
    return res.render('admin/message-client', {
        activePage: 'message-client',
    });
});

router.get('/admin/change-password', authorizeAdminView, async (req, res) => {
    return res.render('admin/change-password', {
        activePage: 'change-password',
    });
});

module.exports = router;
