const express = require('express');
const dotenv = require('dotenv');
const path = require('path');
const formData = require('express-form-data');
const session = require('express-session');
const sessionStoreFactory = require('express-session-sequelize');
const os = require('os');
const { sequelize } = require('./models');

const app = express();
const SequelizeStore = sessionStoreFactory(session.Store);
const sessionStore = new SequelizeStore({
    db: sequelize,
});

dotenv.config();
const PORT = process.env.PORT || 3000;
const formOptions = {
    uploadDir: os.tmpdir(),
    autoClean: true
};
const sessionOptions = {
    store: sessionStore,
    name: 'sessID',
    secret: process.env.APP_SECRET,
    resave: false,
    saveUninitialized: false,
    cookie: {
        maxAge: 7 * 24 * 60 * 60 * 1000,
    }
};

// routes
const {
    adminRoutes,
    authRoutes,
    parcelRoutes,
    utilRoutes
} = require('./routes/api');
const {
    homeViewRoutes,
    adminViewRoutes,
} = require('./routes/views');

// Set view engine
app.set('view engine', 'ejs');

// general middlewares
app.use(session(sessionOptions));
app.use(express.json());
app.use(express.urlencoded({ extended: false }));
app.use(formData.parse(formOptions));
app.use('/v1', [
    adminRoutes,
    authRoutes,
    parcelRoutes,
    utilRoutes
]);
app.use([
    homeViewRoutes,
    adminViewRoutes
]);
app.use('/uploads', express.static(path.join(__dirname, 'uploads')));
app.use(express.static(path.join(__dirname, 'public')));

app.listen(PORT, () => {
    console.log(`${process.env.APP_NAME} ${process.env.NODE_ENV} server running on port: ${PORT}`);
});
