const mv = require('mv');

const fileUploader = (req, res, folder, fieldName) => {
    return new Promise((resolve, reject) => {
      const file = req.files[fieldName];
      if (!file) {
        return resolve({ 
          data: null,
          err: `No file found`
        });
      }
      
      const oldPath = file.path;
      const fileExt = file.name.split('.').pop();
      const fileSize = file.size;   
      const fileType = file.type;
      const newFileName = `${Date.now()}.${fileExt}`;
      const newPath = `./uploads/${folder}/${newFileName}`;
      const allowedTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/jpg', 'image/webp'];
      const maxSize = 2 * 1024 * 1024;

      if (!fileType) {
        return resolve({ 
          data: null,
          err: `No file found`
        });
      }
  
      if (fileSize > maxSize) {
        return resolve({ 
          data: null,
          err: `File exceeds max file size of ${maxSize} bytes.`
        });
      }
  
      if (!allowedTypes.includes(fileType)) {
        return resolve({ 
          data: null,
          err: `Invalid file type ${fileType}. Allowed file types are ${allowedTypes.toString()}.`,
        });
      }

      mv(oldPath, newPath, (err) => {
        if (err) {
          return reject(new Error(err));
        }

        const fileData = {
          name: newFileName,
          size: fileSize,
          path: newPath,
          type: fileType
        };
  
        return resolve({ 
          data: fileData,
          err: null
        });
      });
    });
};

module.exports = fileUploader;
