const fs = require('fs');
const path = require('path');
const ejs = require('ejs');
const { Parcel } = require('../models');

const generateDoc = async (templateName, parcelId) => {
    try {
        const parcel = await Parcel.findOne({
            where: { parcelId }
        });

        if (!parcel) {
            throw new Error("Parcel not found");
        }

        const html = fs.readFileSync(path.join(__dirname, '../utils/templates', templateName), 'utf-8');
        const template = ejs.compile(html);
        const htmlTemplate = template(parcel);
        
        return htmlTemplate;
    } catch (error) {
        throw error;
    }
};

module.exports = generateDoc;
