const ejs = require('ejs');
const nodemailer = require('nodemailer');
const path = require('path');

const sendMail = (to, subject, dataObject, template) => {
    return new Promise((resolve, reject) => {
        const transporter = nodemailer.createTransport({
            host: process.env.MAIL_HOST,
            port: process.env.MAIL_PORT,
            secure: true,
            auth: {
                user: process.env.MAIL_USERNAME,
                pass: process.env.MAIL_PASSWORD
            }
        });

        ejs.renderFile(path.join(__dirname, '../utils/templates', template), dataObject, async (err, renderedHTML) => {
            if (err) {
                reject(err);
                return;
            }

            try {
                const email = await transporter.sendMail({
                    from: `${process.env.APP_NAME} <${process.env.MAIL_FROM}>`,
                    to,
                    subject,
                    html: renderedHTML,
                });
                resolve(email);
            } catch (error) {
                reject(error);
            }
        });
    });
};

module.exports = sendMail;
